/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DefaultDatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.AbstractPersistGameAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

final class UpdateGameAction
extends AbstractPersistGameAction {
    private static final String GET_GAME_ID_BY_NAME_STATEMENT = "SELECT ID FROM game WHERE name=? AND IDDB=?";
    private static final String UPDATE_GAME_STATEMENT = "UPDATE game SET name=?, info=?, machine=?, romA=?, extension_rom=?, romB=?,diskA=?, diskB=?, tape=?, harddisk=?, laserdisc=?, tcl_script=?,msx=?, msx2=?, msx2plus=?, turbo_r=?, psg=?, scc=?, scc_i=?, pcm=?,msx_music=?, msx_audio=?, moonsound=?, midi=?, genre1=?, genre2=?,msx_genid=?, screenshot_suffix=?, sha1=?, size=?, IDDB=?, fdd_mode=?, tcl_script_override=?,input_device=?, connect_gfx9000=? WHERE id=?";
    private final Game oldGame;
    private final Game newGame;
    private final String database;

    UpdateGameAction(Game oldGame, Game newGame, String database) {
        this.oldGame = oldGame;
        this.newGame = newGame;
        this.database = database;
    }

    public DefaultDatabaseResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        block43: {
            this.validateGame(this.newGame);
            long databaseId = this.getDatabaseId(connection, this.database);
            try (PreparedStatement statementCheck = connection.prepareStatement(GET_GAME_ID_BY_NAME_STATEMENT);){
                statementCheck.setString(1, this.oldGame.getName());
                statementCheck.setLong(2, databaseId);
                try (ResultSet result = statementCheck.executeQuery();){
                    if (!result.next()) {
                        this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.GAME_NOT_FOUND, this.oldGame.getName()));
                        break block43;
                    }
                    long gameId = result.getInt(1);
                    try (PreparedStatement statementUpdate = connection.prepareStatement(UPDATE_GAME_STATEMENT);){
                        this.setGameStatementFields(statementUpdate, this.newGame, databaseId);
                        statementUpdate.setLong(36, gameId);
                        if (statementUpdate.executeUpdate() == 0) {
                            // empty if block
                        }
                    }
                    catch (SQLException se) {
                        if (this.isDuplicateError(se)) {
                            this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.GAME_ALREADY_EXISTS, this.newGame.getName()));
                            break block43;
                        }
                        LauncherLogger.logException(this, se);
                        this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
                    }
                }
            }
            catch (SQLException se) {
                this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
            }
        }
        return new DefaultDatabaseResponse();
    }
}

